//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.Resource           = function () {
};
SHINKEN.OBJECT.Resource.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    reset     : function () {
        this.content = null;
    },
    getContent: function () {
        if ( !this.content ) {
            this.content = new Audio( this.path );
        }
        return this.content;
    },
    getUUID   : function () {
        return this.uuid;
    },
    getName   : function () {
        return this.label;
    },
    //********************************************  UPDATE *****************************************************//
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {.0
        switch ( key ) {
            case "resource_id" :
                this.uuid = value;
                break;
            case "display_name" :
                this.label = value;
                break;
            case "resource_hash" :
                this.reset();
                this.resource_hash = value;
                this.path          = "/static/" + __SHINKEN_HTTP_START_TIME__ + "/common_ui/sounds/" + this.resource_hash + ".mp3";
                break;
            case "type" :
            case "file_info_path" :
            case "loading_date_time" :
            case "original_name" :
            case "resource_path" :
            case "use_file_provided_by_shinken" :
                this[ key ] = value;
                break;
        }
    }
};