//priority 10
//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.Sorting           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.Sorting';
    this._status        = SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE;
    this._pop_up_status = SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE;
    this._counter       = new SHINKEN.OBJECT.Counter();
};
SHINKEN.OBJECT.Sorting.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    changeToNextStatus: function () {
        switch ( this._status ) {
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE:
                return;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE:
                this.setStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING );
                break;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING:
                this.setStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING );
                break;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING:
                this.setStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE );
                break;
        }
    },
    clickOnButton     : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-header-popup":
                this.changePopUpStatus();
                break;
            case "click-on-option-header-popup":
                this.setStatus( param.status );
                this.setIndex( param.index );
                this.changePopUpStatus( SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE );
                break;
            case "click-on-header":
                this.changeToNextStatus();
                this.setIndex( param );
                break;
        }
    },
    changePopUpStatus : function ( to_set ) {
        if ( !to_set ) {
            to_set = this._pop_up_status === SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE ? SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.OPEN : SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE;
        }
        this._pop_up_status = to_set;
        this.updateDomParent();
    },
    hidePopup         : function () {
        this.changePopUpStatus( SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getStatus                 : function () {
        return this._status;
    },
    getIndex                  : function () {
        return this._counter.getValue();
    },
    setDomParent              : function ( to_set ) {
        this._dom_parent = to_set;
        this.updateDomParent();
    },
    updateDomParent           : function () {
        DOM.Service.setDataSet( this._dom_parent, 'sortingStatus', this._status );
        DOM.Service.setDataSet( this._dom_parent, 'sortingPopUpStatus', this._pop_up_status );
    },
    setIndex                  : function ( to_set ) {
        if ( this._status === SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE ) {
            to_set = SHINKEN.OBJECT.Sorting.CONST.NO_INDEX;
        }
        this._counter.update( "index_sorting", to_set );
    },
    setStatus                 : function ( to_set ) {
        this._status = to_set;
        switch ( this._status ) {
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE:
                break;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE:
                this.setIndex( SHINKEN.OBJECT.Sorting.CONST.NO_INDEX );
                break;
            default:
                break;
        }
        this.updateDomParent();
    },
    computeHtml               : function ( name_parent ) {
        if ( this._status === SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE || this.getDomElement() ) {
            return;
        }
        this.sort_popup_button         = DOM.Service.createElement( "div",
            {
                class  : "shinken-sort-popup-button shinken-2023-arrow-down",
                onclick: "MANAGER.EventManager.clickOnButton(event, 'click-on-header-popup', '" + name_parent + "')"
            } );
        this.sort_priority_dom_element = DOM.Service.createElement( "div", { class: "shinken-list-header-sort-priority" } );
        this.popup_sort_container      = DOM.Service.createElement( "div", { class: "shinken-list-header-sort-popup" } );
        this.computeHtmlSortPriority();
        this.computeHtmlSortPopup( name_parent );
    },
    computeHtmlSortPopup      : function ( name_parent ) {
        DOM.Service.empty( this.popup_sort_container );
        var _increase_option    = this.computeHtmlSortPopupOption( SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING, "shinicon shinicon-sort-increase", _( "shinken_list.sort.increase", [DICTIONARY_COMMON_UI] ), name_parent );
        var _decrease_option    = this.computeHtmlSortPopupOption( SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING, "shinicon shinicon-sort-decrease", _( "shinken_list.sort.decrease", [DICTIONARY_COMMON_UI] ), name_parent );
        var _delete_sort_option = this.computeHtmlSortPopupOption( SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE, "shinkon shinkon-times-bold", _( "shinken_list.sort.remove", [DICTIONARY_COMMON_UI] ), name_parent );
        DOM.Service.addElementTo( _increase_option, this.popup_sort_container );
        DOM.Service.addElementTo( _decrease_option, this.popup_sort_container );
        DOM.Service.addElementTo( _delete_sort_option, this.popup_sort_container );
        DOM.Service.addElementTo( this.popup_sort_container, this.cell_content );
    },
    computeHtmlSortPopupOption: function ( status, icon, label, name_parent ) {
        var to_return   = DOM.Service.createElement( "div",
            {
                class        : "shinken-list-header-sort-popup-option",
                "data-status": status,
                "data-name"  : status,
                onclick      : "MANAGER.EventManager.clickOnButton(event, 'click-on-option-header-popup', '" + name_parent + "')"
            }
        );
        var table       = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-header-sort-popup-option-table" } );
        var tr          = DOM.Service.createElement( "tr", {} );
        var _icon_cell  = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-popup-option-icon-cell" } );
        var _label_cell = DOM.Service.createElement( "td", {}, label );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: icon } ), _icon_cell );
        DOM.Service.addElementTo( _icon_cell, tr );
        DOM.Service.addElementTo( _label_cell, tr );
        DOM.Service.addElementTo( tr, table );
        DOM.Service.addElementTo( table, to_return );
        return to_return;
    },
    computeHtmlSortPriority   : function () {
        var _table                      = DOM.Service.createElement( "table", { class: "shinken-list-header-sort-priority-table shinken-width-100 shinken-user-select-none" } );
        var _tr                         = DOM.Service.createElement( "tr", {} );
        this._counter.dom_element_label = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-number" } );
        var _icon                       = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-icon-cell" } );
        var _icon_decrease              = DOM.Service.createElement( "span", { class: "shinicon shinicon-sort-decrease" } );
        var _icon_increase              = DOM.Service.createElement( "span", { class: "shinicon shinicon-sort-increase" } );
        
        DOM.Service.addElementTo( _icon_decrease, _icon );
        DOM.Service.addElementTo( _icon_increase, _icon );
        DOM.Service.addElementTo( this._counter.dom_element_label, _tr );
        DOM.Service.addElementTo( _icon, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, this.sort_priority_dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Sorting, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.SortingInterface           = function () {
};
SHINKEN.OBJECT.SortingInterface.prototype = {
    initSorting            : function () {
        this.sorting_object = new SHINKEN.OBJECT.Sorting();
        this.sorting_object.init();
    },
    initSortingAvailability: function () {
    },
    makeSortingUnavailable : function () {
        this.sorting_object._status = SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE;
    },
    computeHtmlSorting     : function () {
        this.sorting_object.computeHtml( this.name );
    },
    setDomParentForSorting : function ( to_set ) {
        this.sorting_object.setDomParent( to_set );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    hidePopupSorting    : function () {
        this.sorting_object.hidePopup();
    },
    clickOnButtonSorting: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-header-popup":
            case "click-on-option-header-popup":
            case "click-on-header":
                this.sorting_object.clickOnButton( event, event_name, param );
                break;
        }
    },
    getSortingIndex     : function () {
        return this.sorting_object.getIndex();
    },
    getSortingStatus    : function () {
        return this.sorting_object.getStatus();
    },
    setSortingIndex     : function ( to_set ) {
        return this.sorting_object.setIndex( to_set );
    },
    setSortingStatus    : function ( to_set ) {
        return this.sorting_object.setStatus( to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SortingInterface, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.Sorting.CONST = {
    NO_INDEX    : 0,
    STATUS      : {
        UNAVAILABLE: "UNAVAILABLE",
        NONE       : "NONE",
        INCREASING : "INCREASING",
        DECREASING : "DECREASING"
    },
    POPUP_STATUS: {
        CLOSE: "CLOSE",
        OPEN : "OPEN"
    }
};