//priority 17
//__lib__ lib_common
'use strict';


PROPERTY.InterfaceCommon = function () {
};

PROPERTY.InterfaceCommon.prototype = {
    initDomElement               : function ( element ) {
        this.name          = element.dataset.name;
        this.type          = element.dataset.type;
        this.dom_element   = element;
        this.default_value = element.dataset.defaultValue;
        this.parent_container  = null;
        this.is_disabled     = element.classList.contains( 'shinken-disabled' );
        this.initCounters( null, true );
        this.setIsRequired( element.dataset.isRequired );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onFocus                      : function () {
    },
    onFocusOut                   : function ( dom_element ) {
        this.___onFocusOut( dom_element );
    },
    clickOnSelector              : function ( event ) {
        event.stopPropagation();
        if ( this.is_disabled ) {
            return false;
        }
        var _target_component = this.getSelector();
        _target_component.clickOnSelector( event.target );
        this.hidePopup( _target_component );
    },
    clickOnItemSelector          : function ( key_name, dom_element, target_component ) {
        if ( this.is_disabled ) {
            return false;
        }
        if ( !target_component ) {
            target_component = this.getSelector();
        }
        this.clickOnItemSelector_end( target_component, key_name, dom_element );
    },
    clickOnItemSelector_end      : function ( target_component, key_name, dom_element ) {
        this.___clickOnItemSelector( target_component, key_name, dom_element );
    },
    clickOnInput                 : function () {
        this.hidePopup();
    },
    clickOnCheckboxInput         : function ( name ) {
        this.___clickOnCheckboxInput( name );
    },
    clickOnRadioBtn              : function ( dom_element, value ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( typeof value === "undefined" ) {
            value = dom_element.value;
        }
        this.___clickOnRadioBtn( value );
    },
    keydown                      : function ( event, key_code ) {
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName                      : function () {
        return this.name;
    },
    getLabelViaDom               : function () {
        return this.dom_element.querySelector( '.shinken-property-label .shinken-label' ).innerText;
    },
    getNameOrUUID                : function () {
        return this.getName();
    },
    getParentName                : function () {
        return this.name;
    },
    getState                     : function () {
        return this.state;
    },
    setState                     : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
    },
    setLastItemSelected          : function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    getValue                     : function () {
        return this.value
    },
    setValue                     : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet                        : function () {
        var _to_return = this.getValue();
        return !!_to_return;
    },
    setIsDisable                 : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    setIsRequired                : function ( to_set ) {
        this.is_required = to_set;
    },
    unset                        : function () {
        this.___unset();
    },
    setValueFromUser             : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    isDifferentValue             : function ( value1, value2 ) {
        return value1 !== value2 && SHINKEN.TOOLS.STRING.unescape_xss( value1 ) !== SHINKEN.TOOLS.STRING.unescape_xss( value2 );
    },
    //********************************************  COMPUTE  *********************************************************//
    _computeState                : function () {
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                    : function ( exception ) {
        this.___hidePopup( exception );
    },
    updateView                   : function () {
        this.___updateView();
    },
    getFlatValueLabel            : function () {
    },
    //********************************************  SAVE    **********************************************************//
    getDataToSave                : function () {
        return this.getDataToSaveFinal();
    },
    onClick                      : function () {
    },
};

PROPERTY.AbstractCommon = function () {
};

PROPERTY.AbstractCommon.prototype = {
    //********************************************  VIEW ************************************************//
    ___updateView          : function () {
    },
    //********************************************  GETTER AND SETTER ************************************************//
    ___unset               : function () {
    },
    getSelector            : function () {
    },
    getValue               : function () {
        console.error( "[Abstract - getValue]", "[NOT IMPLEMENTED]", this.type );
    },
    getFlatValue           : function () {
        console.error( "[Abstract - getFlatValue]", "[NOT IMPLEMENTED]", this.type );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnItemSelector : function ( _target_component, key_name ) {
    },
    ___clickOnCheckboxInput: function ( name ) {
    },
    ___clickOnRadioBtn     : function ( value ) {
    },
    ___onFocusOut          : function ( dom_element ) {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___hidePopup           : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, PROPERTY.AbstractCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, SHINKEN.OBJECT.CounterInterface );
