//__lib__ lib_common
'use strict';

PROPERTY.RadioListGeneric           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.RadioListGeneric.prototype = {
    init: function ( dom_element ) {
        this.initDomElement( dom_element );
        this.state                = null;
        this.component_radio_list = new COMPONENT.RadioListGeneric( dom_element, this );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnRadioBtn: function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this._computeState();
        this.updateView();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                break;
            case "value_changed":
                this.component_radio_list.doActionAfter( event_name, param );
                break;
        }
    },
    //********************************************  GET / SET ***********************************************//
    ___unset        : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser: function ( value ) {
        if ( !value ) {
            value = PROPERTY.CONST.COMMON.VALUE.DEFAULT;
        }
        this.clickOnRadioBtn( null, value );
    },
    setDefaultValue : function ( to_set ) {
        this.component_radio_list.setDefaultValue( to_set );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeState: function () {
        //this.setState( PROPERTY.CONST.COMMON.STATE_PROPERTY.USER_SET );
    },
    //********************************************  SAVE     *********************************************************//
    getValue          : function () {
        return this.component_radio_list.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListGeneric, PROPERTY.InterfaceCommon );
