//__lib__ lib_common
'use strict';

PROPERTY.RangeGeneric           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.RangeGeneric.prototype = {
    init: function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input_range         = new COMPONENT.InputRange( dom_element, this );
        this.component_btn_default         = new COMPONENT.Generic( dom_element.querySelector( ".shinken-input-range-radio-element" ) );
        this.component_label_default_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-notification-sound-default-value" ) );
        this.number_digit_after_comma      = 0;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter            : function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                this.component_label_default_input.updateLabel( this.component_btn_default.getValue() + this.component_input_range.getUnit() );
                break;
            case "value_changed":
                this.component_input_range.doActionAfter( event_name, param );
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case "use_default_value":
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    onMoveRangeCursor        : function ( value_to_set, is_default ) {
        if ( this.is_disabled ) {
            return;
        }
        value_to_set = SHINKEN.TOOLS.NUMBER.roundTo( value_to_set, this.number_digit_after_comma );
        this.component_input_range.setValueFromUser( value_to_set );
        this.changeDefaultButtonStatus( is_default ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
    },
    ___clickOnRadioBtn       : function ( value ) {
        var _value_to_set = this.default_value;
        this.component_input_range.setValue( _value_to_set );
    },
    changeDefaultButtonStatus: function ( value ) {
        this.component_btn_default.setState( value );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', value );
        if ( this.component_btn_default.isOn() ) {
            this.component_input_range.setValueFromUser( this.component_btn_default.getValue() );
        }
    },
    setDefaultValue          : function ( to_set ) {
        this.component_input_range.setDefaultValue( to_set );
        this.component_btn_default.setValue( to_set );
    },
    ___unset                 : function () {
        this.setValueFromUser( "" );
    },
    setValueFromUser         : function ( value ) {
        var is_default = false;
        if ( value === PROPERTY.CONST.COMMON.VALUE.DEFAULT || value === undefined ) {
            value      = this.component_btn_default.getValue();
            is_default = true;
        }
        this.onMoveRangeCursor( parseFloat( value ), is_default );
    },
    //********************************************  GETTER SETTER    *********************************************************//
    getValue: function () {
        return this.component_input_range.getValue();
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RangeGeneric, PROPERTY.InterfaceCommon );