//__lib__ lib_common
'use strict';

WINDOW.ElementGroup           = function ( name ) {
    //dom_element
    //size
    this.name = SHINKEN.TOOLS.STRING.escapeBackslash( name );
    this.list = {};
    this.init();
};
WINDOW.ElementGroup.prototype = {
    init       : function () {
        this.initCounters();
    },
    initWindows: function () {
    },
    //********************************************  GETTER SETTER  **************************************************//
    getActiveWindow                 : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.list[ _keys[ i ] ].is_active ) {
                return this.list[ _keys[ i ] ];
            }
        }
        return null;
    },
    clickOnWindow                   : function ( window_name ) {
        var _active_window = this.getActiveWindow();
        if ( _active_window && _active_window.getName() === window_name ){
            return;
        }
        var _current_window = this.getWindowByName(window_name);
        if ( _current_window && _current_window.is_disabled ){
            return;
        }
        var _keys = Object.keys( this.list );
        var _current;
        var current_window;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            _current.setActive( _current.getName() === window_name );
            if ( _current.is_active ) {
                current_window = _current;
            }
        }
        if ( current_window.hasProperties() ) {
            MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES, window_name );
        }
        this._doExtraActionAfterClickOnWindow( window_name );
    },
    _doExtraActionAfterClickOnWindow: function ( window_name ) {
    },
    getWindowByName                 : function ( window_name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === window_name ) {
                return _current;
            }
        }
    },
    getElementByID                  : function ( id ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getID() === id ) {
                return _current;
            }
        }
        return null;
    },
    getElementByName                : function ( name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === name ) {
                return _current;
            }
        }
        return null;
    },
    getDomElementTargets            : function () {
        return this.dom_element_targets;
    },
    setParentCounter                : function ( parent ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].setParentCounter( parent );
        }
    },
    setContentDomElementTarget      : function ( window_name, to_set ) {
        var _to_return = this.getWindowByName( window_name );
        this.getWindowByName( window_name ).setContentDomElementTarget( to_set );
        return _to_return;
    },
    hasProblems                     : function ( window_name ) {
        return this.getWindowByName(window_name).hasProblems();
    },
    focusOnFirstWindowWithProblem: function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if (this.list[_keys[i]].hasProblems() ) {
                this.clickOnWindow(this.list[_keys[i]].name);
                return;
            }
        }
    },
    //********************************************  OTHERS  **************************************************//
    pulsateElementIfNotActive: function ( window_name ) {
        if ( this.getActiveWindow().getName() !== window_name ) {
            DOM.Service.askAddClass( this.getElementByName( window_name ).dom_element, 'shinken-pulsate', 2000 );
        }
    },
    cancelUserModification   : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].cancelUserModification();
        }
    },
    
    //********************************************  SAVE  **************************************************//
    getDataToSave: function () {
        var _keys      = Object.keys( this.list );
        var _to_return = [];
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, this.list[ _keys[ i ] ].getDataToSave() );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.ShinkenObjectHtml );
