#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn
from .shinken_object import ShinkenObject


class Counter(ShinkenObject):
    def __init__(self, class_to_add, number=u'', label=u'', extra_attribute=u''):
        # type: (unicode, unicode, unicode, unicode) -> None
        super(Counter, self).__init__()
        self.class_to_add = class_to_add
        self.number = number
        self.label = u''
        self.extra_attribute = extra_attribute
        self.set_label(label)
    
    
    def set_label(self, to_set):
        # type: (unicode)-> NoReturn
        self.label = u''
        if to_set:
            self.label = u'''<span class="shinken-counter-extra-label">%s</span>''' % to_set
    
    
    def get_html(self):
        # type: ()-> unicode
        return u'''<span class="shinken-counter %s" data-number="%s" %s %s><span class="shinken-counter-label">%s%s</span></span>''' \
               % (self.class_to_add, self.number, self.extra_attribute, self.tooltip.get_html(), self.number, self.label)
