#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn
from ...object.shinken_object import ShinkenObject


class TagHtml(ShinkenObject):
    def __init__(self, tag, internal_class='', attribute=''):
        # type: (unicode, unicode, unicode)-> NoReturn
        super(TagHtml, self).__init__(None)
        self._tag = tag
        self.add_class(internal_class)
        self._attribute = attribute
    
    
    def set_tag(self, to_set):
        # type: (unicode)-> NoReturn
        self._tag = to_set
    
    
    def get_opening_tag_html(self):
        # type: ()-> unicode
        return '''<%s class="%s" %s %s>''' % (self._tag, self._class, self._attribute, self.tooltip.get_html())
    
    
    def get_closing_tag_html(self):
        # type: ()-> unicode
        return '''</%s>''' % self._tag
