#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING
from shinken.toolbox.pickledb import ShinkenPickleableMeta

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Union, Tuple, List


class ShinkenUIPropertyBadValue(object):
    __metaclass__ = ShinkenPickleableMeta
    
    
    def __init__(self, value):
        # type: (Any, Any) -> None
        self.value = value
        self.validation_status = None
        self.trad_key = None
        self.trad_args = None
        self.css_cls = None
    
    
    def set_translate_variables(self, validation_status, trad_key, trad_args):
        # type: (unicode, unicode, Union[List, unicode, Tuple]) -> None
        self.validation_status = validation_status
        self.trad_key = trad_key
        self.trad_args = trad_args
    
    
    def to_json(self):
        return self.value
    
    
    def __copy__(self):
        _new_bad_value = ShinkenUIPropertyBadValue(self.value)
        _new_bad_value.trad_key = self.trad_key
        _new_bad_value.trad_args = self.trad_args
        _new_bad_value.css_cls = self.css_cls
        return _new_bad_value


class ShinkenUIPropertyBadInheritedValue(ShinkenUIPropertyBadValue):
    @staticmethod
    def from_bad_value(original_bad_value):
        # type: (ShinkenUIPropertyBadValue) -> ShinkenUIPropertyBadInheritedValue
        return ShinkenUIPropertyBadInheritedValue(original_bad_value.value)


class ShinkenUIPropertyBadInheritedValueFromConfig(ShinkenUIPropertyBadInheritedValue):
    @staticmethod
    def from_bad_value(original_bad_value):
        # type: (ShinkenUIPropertyBadValue) -> ShinkenUIPropertyBadInheritedValueFromConfig
        return ShinkenUIPropertyBadInheritedValueFromConfig(original_bad_value.value)
