#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING
from .table_line import TableLine
from ..object.shinken_object import ShinkenObject

if TYPE_CHECKING:
    from shinkensolutions.api.synchronizer import TranslatePart
    from shinken.misc.type_hint import NoReturn, List


class TableBody(ShinkenObject):
    def __init__(self, translate=None):
        # type: (TranslatePart)-> NoReturn
        super(TableBody, self).__init__(translate)
        self.add_class('shinken-list-tbody shinken-list-line')
        self._lines = []  # type: List[TableLine]
    
    
    # ****************************************************** GETTER SETTER  ***************************************
    def get_line(self, index):
        # type: (int)-> TableLine
        return self._lines[index]
    
    
    def add_line(self, table_line):
        # type: (TableLine)-> NoReturn
        table_line._class = ''
        self._lines.append(table_line)
    
    
    # ****************************************************** HTML  ***************************************
    
    def get_html(self):
        # type: ()-> str
        _to_return = ['''<tbody %s''' % self.get_object_tag_html()]
        for _line in self._lines:
            _to_return.append(_line.get_html())
        _to_return.append('''</tbody>''')
        return ''.join(_to_return)
