#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ..object.shinken_object import ShinkenObject

if TYPE_CHECKING:
    from shinkensolutions.api.synchronizer import TranslatePart
    from shinken.misc.type_hint import NoReturn, Optional


class TableCell(ShinkenObject):
    def __init__(self, value, translate=None, class_to_add=u'', row_span=None, col_span=None):
        # type: (unicode, TranslatePart, unicode, Optional[int], Optional[int])-> NoReturn
        super(TableCell, self).__init__(translate)
        self.add_class(u'shinken-list-cell')
        self.add_class(class_to_add)
        self.add_class_content(u'shinken-list-cell-content')
        self._content = value
        self._colspan = None  # type: Optional[int]
        self._rowspan = None  # type: Optional[int]
        self.set_col_span(col_span)
        self.set_row_span(row_span)
    
    
    def set_col_span(self, to_set):
        # type: (int) -> NoReturn
        self._colspan = to_set
    
    
    def set_row_span(self, to_set):
        # type: (int) -> NoReturn
        self._rowspan = to_set
    
    
    def set_value(self, to_set):
        # type: (unicode) -> NoReturn
        self._content = to_set
    
    
    # ****************************************************** HTML  ***************************************
    
    def get_row_span_html(self):
        # type: () -> unicode
        return u'''rowspan=%s''' % self._rowspan if self._rowspan else u''
    
    
    def get_col_span_html(self):
        # type: () -> unicode
        return u'''colspan=%s''' % self._colspan if self._colspan else u''
    
    
    def get_html(self):
        # type: () -> unicode
        return u'''<td %s %s %s><div class="%s">%s</div></td>''' % (self.get_object_tag_html(), self.get_row_span_html(), self.get_col_span_html(), self._class_content, self._content)


class TableCellHeader(TableCell):
    def __init__(self, value, translate=None, class_to_add=u''):
        # type: (unicode, TranslatePart, unicode) -> NoReturn
        super(TableCellHeader, self).__init__(value, translate=translate, class_to_add=class_to_add)
        self._class = u'shinken-list-header'
        self.add_class(class_to_add)
