#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from ..object.counter import Counter
from ..object.shinken_object import ShinkenObject


class Window(ShinkenObject):
    def __init__(self, name, group_name, _id_=None, extra_class=u'', label=u''):
        # type: (unicode, unicode, unicode, unicode, unicode) -> None
        super(Window, self).__init__()
        self.name = name
        self.group_name = group_name
        self._id_ = _id_
        self.extra_class = extra_class
        self.extra_attribute = u''
        self.label = label
        self.warning_counter = Counter(u'shinken-error-counter')
        self.error_counter = Counter(u'shinken-warning-counter')
    
    
    # *****************************   HTML  ************************************************************#
    
    def get_main_line_html(self):
        # type: () -> unicode
        _to_return = [u'''<td class="shinken-window-element %s" %s''' % (self.extra_class, self.extra_attribute)]
        if self._id_:
            _to_return.append(u''' id="%s"''' % self._id_)
        _to_return.append(u''' data-name="%s"''' % self.name)
        _to_return.append(u''' data-group-name="%s">''' % self.group_name)
        return u''.join(_to_return)
    
    
    def get_html(self):
        # type: () -> unicode
        _to_return = [
            u'''%s''' % (self.get_main_line_html()),
            u'''<span class="shinken-window-element-label">''',
            u'''%s''' % self.error_counter.get_html(),
            u'''%s''' % self.warning_counter.get_html(),
            u'''<span class="shinken-window-label">%s</span>''' % self.label or self.name,
            u'''</span>''',
            u'''</td>'''
        ]
        return u''.join(_to_return)
