#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any


# Backport of contextlib.nullcontext() from Python 3.7
class nullcontext(object):  # noqa: Act as a function call (but for a 'with' statement)
    def __init__(self, return_value=None):
        self.return_value = return_value  # type: Any
    
    
    def __enter__(self):
        return self.return_value
    
    
    def __exit__(self, exc_type, exc_val, exc_tb):
        return None
