#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import List, Dict, Any


def clear_none_in_object(obj):
    # type: (Any) -> None
    if isinstance(obj, dict):
        recursively_clear_none_in_dict(obj)
    elif isinstance(obj, list):
        recursively_clear_none_in_list(obj)


def recursively_clear_none_in_list(list_to_clear):
    # type: (List) -> None
    list_to_clear[:] = [v for v in list_to_clear if v is not None]
    for value in list_to_clear:
        clear_none_in_object(value)


def recursively_clear_none_in_dict(dict_to_clear):
    # type: (Dict) -> None
    for key in dict_to_clear.keys():
        value = dict_to_clear[key]
        if value is None:
            del dict_to_clear[key]
        else:
            clear_none_in_object(value)
