# !/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
from abc import ABCMeta, abstractmethod

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.abstract_base_class import abstractclassmethod

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, List, Optional


class AbstractListFilterItem(object):
    __metaclass__ = ABCMeta
    
    
    @abstractclassmethod
    def get_valid_keys(cls):
        # type: () -> List[unicode]
        # Must return the list of the keys needed for the 'from_dict' method
        raise NotImplementedError()
    
    
    @abstractclassmethod
    def from_dict(cls, filter_dict):
        # type: (Dict[unicode, unicode]) -> AbstractListFilterItem
        raise NotImplementedError()
    
    
    @abstractmethod
    def apply_on(self, list_to_filter):
        # type: (List[Any]) -> List[Any]
        raise NotImplementedError()
    
    
    def get_additional_information_from_non_filtered_list(self, object_list, info_dict=None):  # noqa: overridable
        # type: (List[Any], Optional[Dict[unicode, Any]]) -> Dict[unicode, Any]
        if info_dict is None:
            return {}
        return info_dict
    
    
    def get_additional_information_from_filtered_list(self, object_list, info_dict=None):  # noqa: overridable
        # type: (List[Any], Optional[Dict[unicode, Any]]) -> Dict[unicode, Any]
        if info_dict is None:
            return {}
        return info_dict
