#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2017:
# This file is part of Shinken Enterprise, all rights reserved.

import platform
import os
from shinken.log import logger

VMWARE_VI_COMMON = '/usr/share/perl5/VMware/VICommon.pm'


def is_centos_redhat():
    # only check linux, not windows
    if os.name != 'posix':
        logger.debug('check_vmware_sdk:: not linux, skipping')
        return False
    # Only check if redhat/centos 7.X
    _linux, _, _ = platform.linux_distribution()
    _linux = _linux.lower()
    if 'centos' in _linux or 'redhat' in _linux:
        return True
    return False


def get_linux_version():
    _, _version, _ = platform.linux_distribution()
    return _version


def is_vmware_sdk_installed():
    return os.path.exists(VMWARE_VI_COMMON)


def is_vmware_sdk_patched():
    # look if the lib "/opt/vmware_perl_libwww/lib/perl5" is loaded in the VMWare sdk (/usr/share/perl5/VMware/VICommon.pm file)
    f = open(VMWARE_VI_COMMON, 'r')
    buf = f.read()
    lines = buf.splitlines()
    for line in lines:
        if 'vmware_perl_libwww' in line:
            return True
    return False
