#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    pass


class MassActionsException(Exception):
    def __init__(self, message):
        # type: (unicode) -> None
        super(MassActionsException, self).__init__(message)
        self.message = message


class ActionAlreadyRegistered(MassActionsException):
    def __init__(self, action, message=u''):
        # type: (unicode, unicode) -> None
        if not message:
            message = u'Action [ %s ] already registered' % action
        super(ActionAlreadyRegistered, self).__init__(message)
        self.action = action
