#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from abc import ABCMeta, abstractmethod

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.validators.validation import ValidationMessages

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinken.misc.type_hint import Dict, Any, Optional


class ValidationResult(object):
    def __init__(self, should_be_done, messages=None):
        # type: (bool, Optional[ValidationMessages]) -> None
        self.messages = messages or ValidationMessages(warnings=[], errors=[], critical=[])
        self.should_be_done = bool(should_be_done)


class AbstractActionValidator(object):
    __metaclass__ = ABCMeta
    
    
    @abstractmethod
    def validate(self, action_dict, logger=None):
        # type: (Dict[unicode, Any], Optional[PartLogger]) -> ValidationResult
        """
        Validates the action dictionary and optionally modifies it
        """
        raise NotImplementedError()
    
    
    # noinspection PyMethodMayBeStatic
    def pythonize(self, action_dict, logger=None):
        # type: (Dict[unicode, Any], Optional[PartLogger]) -> Any
        """Obtain a specific object from dict"""
        return action_dict


class TrustActionValidator(AbstractActionValidator):
    """Accepts any given data"""
    
    
    def validate(self, action_dict, logger=None):
        # type: (Dict[unicode, Any], Optional[PartLogger]) -> ValidationResult
        return ValidationResult(should_be_done=True)
