#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

import os

import magic

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.webui.resources_management.validate_resource import ACCEPTED_AUDIO_TYPE, AUDIO_MAX_SIZE

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinken.misc.type_hint import Tuple


class RESOURCE_VALIDATOR_TYPE(object):
    AUDIO = u'audio/mpeg'


def init_magic_validator():
    # type: () -> magic
    magic_validator = magic.open(magic.MAGIC_MIME)
    magic_validator.load()
    return magic_validator


def get_resource_type_and_charset(resource_path):
    # type:(unicode) -> Tuple[unicode, unicode]
    
    magic_validator = init_magic_validator()
    full_resource_type = magic_validator.file(resource_path)
    resource_type, charset = full_resource_type.split(u';')
    return resource_type.strip(), charset.strip()


def validate_sound_resource(resource_path, logger):
    # type: (unicode, PartLogger) -> bool
    resource_type, _ = get_resource_type_and_charset(resource_path)
    if resource_type not in ACCEPTED_AUDIO_TYPE:
        logger.warning(u'The file [ %s ] is not of type MP3 (audio/mpeg). It\'s type is "%s". Change your file by a valid file and run this command again.' % (resource_path, resource_type))
        return False
    
    if os.path.getsize(resource_path) > AUDIO_MAX_SIZE:
        logger.warning(u'The file [ %s ] is bigger than maximal size ( 5 Mo Max ). Change your file by a valid file and run this command again.' % resource_path)
        return False
    return True
