#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.os_helper import verify_file_exist_and_can_be_read_by_shinken, verify_if_dir_or_file_exist

if TYPE_CHECKING:
    from shinken.log import PartLogger

MP3_TYPE = u'audio/mpeg'
ACCEPTED_AUDIO_TYPE = [MP3_TYPE]
AUDIO_MAX_SIZE = 5000000


def validate_resource(resource_path, logger, before_copy_in_shinken_user_resource=False):
    # type:(unicode, PartLogger, bool) -> bool
    
    if before_copy_in_shinken_user_resource:
        if not verify_if_dir_or_file_exist(resource_path, logger=logger):
            return False
    else:
        if not verify_file_exist_and_can_be_read_by_shinken(resource_path, logger=logger):
            return False
    return True
