#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

"""
This module contains the patches to apply to a weather JSON in order to upgrade to the version : 2

Register your migration hook function using the @weather_format_patch decorator

Each callback must take the weather dict to modify, and return None
Example:

from ..patch_decorator import weather_format_patch

@weather_format_patch
def add_grid_default(weather_data):  # The parameter name can be anything
    # type: (Dict[unicode, Any]) -> None
    # Do your stuff...
    return

N.B.: The functions will NOT always be called in the same order as the declaration
"""

from shinken.misc.type_hint import TYPE_CHECKING
from .weather_external_links_data import generate_new_weather_external_links
from .weather_grid_data import generate_new_grids
from ..patch_decorator import weather_format_patch

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict


##################################################
#  _____      _     _
# |  __ \    (_)   | |
# | |  \/_ __ _  __| |___
# | | __| '__| |/ _` / __|
# | |_\ \ |  | | (_| \__ \
#  \____/_|  |_|\__,_|___/
##################################################


@weather_format_patch
def update_weather_grids(weather_data):
    # type: (Dict) -> None
    
    # Update all grids
    new_grids = generate_new_grids(weather_data.get(u'grids', []))
    
    # Save the generated grids
    weather_data[u'grids'] = new_grids
    return


##################################################
#  _____     _                        _   _ _       _
# |  ___|   | |                      | | | (_)     | |
# | |____  _| |_ ___ _ __ _ __   __ _| | | |_ _ __ | | _____
# |  __\ \/ / __/ _ \ '__| '_ \ / _` | | | | | '_ \| |/ / __|
# | |___>  <| ||  __/ |  | | | | (_| | | | | | | | |   <\__ \
# \____/_/\_\\__\___|_|  |_| |_|\__,_|_| |_|_|_| |_|_|\_\___/
##################################################


@weather_format_patch
def update_weather_external_links(weather_data):
    # type: (Dict) -> None
    weather_data[u'external_links'] = generate_new_weather_external_links(weather_data.get(u'external_links', {}))
    return
