#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ....utils.weather_tools import travel_dictionaries

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, List, Optional


# WEATHER CONSTANTS ARE FORBIDDEN HERE

def _parse_existing(grid, path, default_value=u'default'):
    # type: (Dict, unicode, Optional[Any]) -> Optional[Any]
    return travel_dictionaries(grid, path, default_value=default_value)


def generate_new_weather_external_links(external_links):
    # type: (Dict) -> Dict
    return {
        u'links__default_link_protocol'        : _parse_link_protocol(external_links, is_layout=True) or _parse_existing(external_links, u'links__default_link_protocol', default_value=u'protocol_from_webui'),
        u'links__default_base_url'             : _parse_link_base_url(external_links, is_layout=True) or _parse_existing(external_links, u'links__default_base_url'),
        u'links__default_external_part_url'    : _parse_link_external_part_url(external_links) or _parse_existing(external_links, u'links__default_external_part_url'),
        u'links__default_authentication_needed': _parse_link_authentication_needed(external_links) or _parse_existing(external_links, u'links__default_authentication_needed'),
        u'links__default_info_bar'             : _parse_link_info_bar(external_links) or _parse_existing(external_links, u'links__default_info_bar', {}),
        u'links'                               : _parse_links(external_links) or _parse_existing(external_links, u'links', []),
    }


def _parse_link_protocol(external_link, is_layout=False):
    # type: (Dict, bool) -> unicode
    base_url = _parse_existing(external_link, u'links__default_base_url' if is_layout else u'link_base_url', u'')
    if base_url.startswith(u'http://'):
        to_return = u'http'
    elif base_url.startswith(u'https://'):
        to_return = u'https'
    else:
        to_return = u'protocol_from_webui'
    
    return to_return


def _parse_link_base_url(external_link, is_layout=False):
    # type: (Dict, bool) -> unicode
    to_return = u''
    base_url = _parse_existing(external_link, u'links__default_base_url' if is_layout else u'link_base_url', u'')
    
    if base_url.startswith(u'http://'):
        to_return = base_url.replace(u'http://', u'')
    elif base_url.startswith(u'https://'):
        to_return = base_url.replace(u'https://', u'')
    return to_return


def _parse_link_external_part_url(external_link, is_layout=False):
    # type: (Dict, bool) -> unicode
    to_return = u''
    
    return to_return


def _parse_link_authentication_needed(external_link, is_layout=False):
    # type: (Dict, bool) -> bool
    to_return = False
    
    return to_return


def _parse_link_info_bar(external_link, is_layout=False):
    # type: (Dict, bool) -> Dict
    to_return = {}
    
    if not is_layout:
        to_return = {
            u'position'        : _parse_existing(external_link, u'info_bar.position'),
            u'background_color': _parse_existing(external_link, u'info_bar.background_color'),
            u'logo_displayed'  : _parse_existing(external_link, u'info_bar.logo_displayed'),
            u'refresh'         : {
                u'chrono_displayed'         : _parse_existing(external_link, u'info_bar.refresh.chrono_displayed'),
                u'generation_time_displayed': _parse_existing(external_link, u'info_bar.refresh.generation_time_displayed', default_value=_parse_existing(external_link, u'info_bar.refresh.text_displayed'))
            }
        }
    
    return to_return


def _parse_links(external_links):
    # type: (Dict) -> List
    to_return = []
    for link in _parse_existing(external_links, u'links', []):
        to_return.append({
            u'link_name'             : _parse_existing(link, u'link_name'),
            u'link_uuid'             : _parse_existing(link, u'link_uuid'),
            u'link_protocol'         : _parse_link_protocol(link),
            u'link_base_url'         : _parse_link_base_url(link) or _parse_existing(link, u'link_base_url'),
            u'link_external_part_url': _parse_existing(link, u'link_external_part_url'),
            u'authentication_needed' : _parse_existing(link, u'authentication_needed'),
            u'info_bar'              : _parse_link_info_bar(link) or _parse_existing(link, u'info_bar')
        })
    
    return to_return
