#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

"""
This module contains the patches to apply to a weather JSON in order to upgrade to the version : 4

Register your migration hook function using the @weather_format_patch decorator

Each callback must take the weather dict to modify, and return None
Example:

from ..patch_decorator import weather_format_patch

@weather_format_patch
def add_grid_default(weather_data):  # The parameter name can be anything
    # type: (Dict[unicode, Any]) -> None
    # Do your stuff...
    return

N.B.: The functions will NOT always be called in the same order as the declaration
"""

from shinken.misc.type_hint import TYPE_CHECKING
from .weather_external_links_data import generate_new_weather_default_external_link

from ..patch_decorator import weather_format_patch

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict


@weather_format_patch
def remove_shinken_json_uuid(weather_data):
    grids = weather_data.get(u'grids', [])
    for grid in grids:
        grid_elements = grid.get(u'grid_elements', [])
        for grid_element in grid_elements:
            grid_element.pop(u'__SHINKEN_JSON_UUID__', None)


##################################################
#  _____     _                        _   _ _       _
# |  ___|   | |                      | | | (_)     | |
# | |____  _| |_ ___ _ __ _ __   __ _| | | |_ _ __ | | _____
# |  __\ \/ / __/ _ \ '__| '_ \ / _` | | | | | '_ \| |/ / __|
# | |___>  <| ||  __/ |  | | | | (_| | | | | | | | |   <\__ \
# \____/_/\_\\__\___|_|  |_| |_|\__,_|_| |_|_|_| |_|_|\_\___/
##################################################


@weather_format_patch
def update_weather_default_external_link(weather_data):
    # type: (Dict) -> None
    external_links = weather_data.setdefault(u'external_links', {})
    external_links[u'default_link'] = generate_new_weather_default_external_link(external_links)
    external_links.pop(u'links__default_info_bar', None)
    external_links.pop(u'links__default_authentication_needed', None)
    external_links.pop(u'links__default_link_protocol', None)
    external_links.pop(u'links__default_base_url', None)
    external_links.pop(u'links__default_external_part_url', None)
