#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ....utils.weather_tools import travel_dictionaries

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, Optional


# WEATHER CONSTANTS ARE FORBIDDEN HERE

def _parse_existing(grid, path, default_value=u'default'):
    # type: (Dict, unicode, Optional[Any]) -> Optional[Any]
    return travel_dictionaries(grid, path, default_value=default_value)


def generate_new_weather_default_external_link(external_links):
    # type: (Dict) -> Dict
    return {
        u'link_protocol'         : _parse_existing(external_links, u'links__default_link_protocol', default_value=u'protocol_from_webui'),
        u'link_base_url'         : _parse_existing(external_links, u'links__default_base_url'),
        u'link_external_part_url': _parse_existing(external_links, u'links__default_external_part_url'),
        u'authentication_needed' : _parse_existing(external_links, u'links__default_authentication_needed'),
        u'info_bar'              : _parse_existing(external_links, u'links__default_info_bar', {}),
    }
