#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
from itertools import chain

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional


def find_weather_view_name(weather_dict):
    # type: (Dict) -> Optional[unicode]
    for grid_element in chain.from_iterable(grid.get(u'grid_elements', []) for grid in weather_dict.get(u'grids', [])):
        content = grid_element.get(u'content', {})
        if content.get(u'type', None) == u'title_widget':
            return content.get(u'layout', {}).get(u'information_to_display', {}).get(u'title_area', {}).get(u'label', None)
    return None
