#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional, Any


def travel_dictionaries(dictionary, dotted_keys, default_value=None):
    # type: (Dict, unicode, Optional[Any]) -> Optional[Any]
    """
    Get a value in depth from a dictionary
    
    Example:
        travel_dictionaries(dict, "a.b") == dict["a"]["b"]
    """
    keys = [name for name in dotted_keys.split(u'.') if name]
    if not keys:
        return default_value
    
    to_return = dictionary
    for key in keys:
        try:
            to_return = to_return[key]
        except (KeyError, TypeError):
            return default_value
    return to_return


def change_existing_value_if_equals_to(value, value_to_replace, replace_with):
    # type: ( unicode, unicode, unicode) -> unicode
    if value == value_to_replace:
        return replace_with
    return value
