#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

# It was named aaaa for be the first in automatic import
import sys
import ssl

from shinken.thread_helper import patch_thread_name

try:
    from cheroot.ssl.builtin import BuiltinSSLAdapter
    from cheroot.server import HTTPServer
    
    
    def get_environ(self, sock):
        """Create WSGI environ entries to be merged into each request."""
        cipher = sock.cipher()
        ssl_environ = {
            'wsgi.url_scheme'      : 'https',
            'HTTPS'                : 'on',
            'SSL_PROTOCOL'         : cipher[1],
            'SSL_CIPHER'           : cipher[0],
            'SSL_CIPHER_EXPORT'    : '',
            'SSL_CIPHER_USEKEYSIZE': cipher[2],
            'SSL_VERSION_INTERFACE': '%s Python/%s' % (
                HTTPServer.version, sys.version,
            ),
            'SSL_VERSION_LIBRARY'  : ssl.OPENSSL_VERSION,
            'SSL_CLIENT_VERIFY'    : 'NONE',
            # 'NONE' - client did not provide a cert (overriden below)
        }
        return ssl_environ
    
    
    BuiltinSSLAdapter.get_environ = get_environ
except ImportError:
    BuiltinSSLAdapter = None
    HTTPServer = None

patch_thread_name()
