#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2022:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.lib_modules.configuration_reader_mixin import ConfigurationReader

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, List, Optional
    from shinken.objects.module import Module as ShinkenModuleDefinition


class ModuleInfoReaderMixin(object):
    def __init__(self, mod_conf):
        # type: (ShinkenModuleDefinition) -> None
        self.props = mod_conf.properties.copy()
        self.properties = self.props
        self.is_external = self.props.get('external', False)
        self._module_on_type = self.props.get('daemons', False)
        self._module_type = self.props.get('type', False)
        
        # though a module defined with no phase is quite useless .
        self.phases = self.props.get('phases', [])
        self.phases.append(None)
    
    
    def get_module_info_from_json(self):
        # type: () -> Optional[Dict]
        return self.props
    
    
    def get_standard_configuration_parameter_format(self):
        # type: () -> Optional[List]
        module_info = self.get_module_info_from_json()
        if not module_info:
            return None
        standard_parameter_data = module_info.get('standard_configuration_parameters', None)
        return ConfigurationReader.configuration_format_from_loaded_json(standard_parameter_data, logger=getattr(self, 'logger', None))
    
    
    def get_mongodb_configuration_parameter_prefix(self):
        # type: () -> Optional[str]
        module_info = self.get_module_info_from_json()
        if not module_info:
            return None
        return module_info.get('mongodb_configuration_parameters_prefix', None)
