#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

try:
    from shinken.synchronizer.dao.def_items import DEF_ITEMS, ITEM_TYPE
except ImportError:
    from synchronizer.dao.def_items import DEF_ITEMS, ITEM_TYPE

if TYPE_CHECKING:
    from shinken.misc.type_hint import Union
    from synchronizer.dao.items import ContactItem


class ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW_DEFAULT_VALUE(object):
    NOBODY = 'nobody'
    EVERYONE = 'everybody'
    IS_ADMIN_SHINKEN = 'is_admin_shinken'
    MAPPED_VALUES = {
        NOBODY          : '0',
        EVERYONE        : '1',
        IS_ADMIN_SHINKEN: IS_ADMIN_SHINKEN
    }
    
    
    @staticmethod
    def is_valid_default_value(value):
        # type: (unicode) -> bool
        return value in [ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW_DEFAULT_VALUE.NOBODY,
                         ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW_DEFAULT_VALUE.EVERYONE,
                         ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW_DEFAULT_VALUE.IS_ADMIN_SHINKEN]
    
    
    @staticmethod
    def get_mapped_value(value):
        # type: (unicode) -> unicode
        return ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW_DEFAULT_VALUE.MAPPED_VALUES[value]
    
    
    @staticmethod
    def compute_value(item):
        # type: (Union[ContactItem, dict]) -> bool
        _default_value = DEF_ITEMS[ITEM_TYPE.CONTACTS]['class'].properties['acl_change_element_visibility_on_not_authenticated_view'].default
        _value = item.get('acl_change_element_visibility_on_not_authenticated_view', _default_value)
        if _value == ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW_DEFAULT_VALUE.IS_ADMIN_SHINKEN:
            _value = item.get('is_admin', '0')
        return _value == '1'
