#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.
#

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import NoReturn, Union
    from shinken.log import PartLogger


class ERROR_LEVEL(object):
    ERROR = 'ERROR'
    WARNING = 'WARNING'
    FATAL = 'FATAL'


class ErrorHandler(object):
    def handle_exception(self, message, exception, _logger, level):
        # type: (str, Union[str,Exception], PartLogger, str) -> NoReturn
        raise NotImplementedError()
