#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.
#
#
# File auto-generated

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Set


# Contains default pickleable objects validated by Shinken
_SAFE_PICKLEABLE_CLASSES_DATABASE = {
    '__builtin__': {'bool', 'complex', 'dict', 'float', 'frozenset', 'int', 'list', 'long', 'object', 'set', 'slice', 'str', 'tuple', 'unicode', 'xrange'},  # noqa: Auto-generated
    'builtins': {'bool', 'bytes', 'complex', 'dict', 'float', 'frozenset', 'int', 'list', 'object', 'range', 'set', 'slice', 'str', 'tuple'},  # noqa: Auto-generated
    'collections': {'Counter', 'OrderedDict', 'defaultdict', 'deque'},  # noqa: Auto-generated
    'copy_reg': {'_reconstructor'},  # noqa: Auto-generated
    'copyreg': {'_reconstructor'},  # noqa: Auto-generated
    'ordereddict': {'OrderedDict'},  # noqa: Auto-generated
    'shinken.toolbox.pickledb': {'ShinkenUnpickler'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.button.generic_button': {'GenericButton'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.input': {'InputStringComp'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.radio_list': {'RadioListComp', 'RadioListCumulativeComp'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.radio_list_element': {'RadioListElement'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.select': {'SelectComp'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.shinken_grid': {'ShinkenGrid'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.shinken_grid_element': {'ShinkenGridElement'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.shinken_grid_element_template': {'ShinkenGridElementTemplate'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.square': {'Point', 'Square'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.counter': {'Counter'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.empty_object': {'EmptyObject'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.label': {'LabelHtml'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.one_line_table_html': {'OneLineTableHtml'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.tag': {'TagHtml'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.tag_generic': {'TagGeneric'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.messages': {'Message', 'Messages', 'ValidatorMessage', 'ValidatorMessages'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_object': {'ShinkenObject', 'ShinkenObjectContainer'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.abstract_shinken_ui_composite': {'AbstractShinkenUIComposite'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.shinken_ui_containers': {'AbstractShinkenUIContainer', 'ShinkenUIList', 'ShinkenUIObject'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.shinken_ui_property': {'AbstractShinkenUINumberProperty', 'AbstractShinkenUIProperty', 'ShinkenUIAnyProperty', 'ShinkenUIBoolProperty', 'ShinkenUIEnumProperty', 'ShinkenUIFloatProperty', 'ShinkenUIIntegerOrEnumProperty', 'ShinkenUIIntegerProperty', 'ShinkenUIStringProperty'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.shinken_ui_property_bad_value': {'ShinkenUIPropertyBadInheritedValue', 'ShinkenUIPropertyBadInheritedValueFromConfig', 'ShinkenUIPropertyBadValue'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.table.table_body': {'TableBody'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.table.table_cell': {'TableCell', 'TableCellHeader'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.table.table_line': {'TableLine', 'TableLineHeader', 'TableLineTbody'},  # noqa: Auto-generated
    'shinkensolutions.common_ui.window.window': {'Window'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub': {'DataHubConfig'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_backup.data_hub_backup': {'DataHubBackup', 'DataHubsBackup'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver': {'AbstractDataHubDriverConfig'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_database': {'AbstractDataHubDriverConfigDatabase'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_file': {'AbstractDataHubDriverConfigFile'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_cPickle': {'DataHubDriverConfigPickle'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_data_hub_config_file': {'DataHubDriverConfigDataHubConfigFile'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_json': {'DataHubDriverConfigJson'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_mmap_file': {'DataHubDriverConfigMmapFile'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_mongo': {'DataHubDriverConfigMongo'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_cache': {'DataHubMetaDriverConfigCache'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_cleanup_directory': {'DataHubMetaDriverConfigCleanupDirectory'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_replication': {'DataHubMetaDriverConfigReplication'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_retention': {'DataHubMetaDriverConfigRetention'},  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_utils.data_hub_unpickler': {'DataHubUnpickler'},  # noqa: Auto-generated
    'shinkensolutions.validators.validation': {'ValidationMessages'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.validators.weather_validator_message': {'WeatherValidatorMessages'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.info_bar.weather_external_link_info_bar': {'WeatherExternalLinkInfoBar'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.info_bar.weather_external_link_info_bar_refresh': {'WeatherExternalLinkInfoBarRefresh'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.weather_external_link': {'WeatherExternalLink'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.weather_external_link_layout': {'WeatherExternalLinkLayout'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.weather_external_links': {'WeatherExternalLinks'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.grids.weather_grid': {'WeatherGrid'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.grids.weather_grid_layouts_container': {'WeatherGridLayoutsContainer'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.visual.weather_blink_visual_notification': {'WeatherBlinkVisualNotification'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_notification_interface': {'WeatherNotificationInterface'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_notifications': {'WeatherNotifications'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_sound_notification': {'WeatherSoundNotification'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_visual_notifications': {'WeatherVisualNotifications'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.users.weather_user': {'WeatherUser'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.users.weather_users': {'WeatherUsers'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather': {'Weather', 'WeatherGridsList', 'WeatherIdentity'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather_element_data': {'WeatherElementData'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather_grid_elements': {'WeatherGridElements'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather_object_interface': {'WeatherObjectInterface'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.content': {'SeparatorWidgetContent'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.content_template': {'SeparatorWidgetContentTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display': {'SeparatorWidgetContentLayoutInformationToDisplay'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_left_area': {'SeparatorWidgetContentLayoutInformationToDisplayLeftArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_right_area': {'SeparatorWidgetContentLayoutInformationToDisplayRightArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_template': {'SeparatorWidgetContentLayoutInformationToDisplayTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_title_area': {'SeparatorWidgetContentLayoutInformationToDisplayTitleArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_title_area_template': {'SeparatorWidgetContentLayoutInformationToDisplayTitleAreaTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.layout': {'SeparatorWidgetContentLayout'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.layout_template': {'SeparatorWidgetContentLayoutTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.separator_widget': {'SeparatorWidget'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.separator_widget_template': {'SeparatorWidgetTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.content': {'TitleWidgetContent'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.content_template': {'TitleWidgetContentTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display': {'TitleWidgetContentLayoutInformationToDisplay'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display_template': {'TitleWidgetContentLayoutInformationToDisplayTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display_title_area': {'TitleWidgetContentLayoutInformationToDisplayTitleArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display_title_area_template': {'TitleWidgetContentLayoutInformationToDisplayTitleAreaTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.layout': {'TitleWidgetContentLayout'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.layout_template': {'TitleWidgetContentLayoutTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.title_widget': {'TitleWidget'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.title_widget_template': {'TitleWidgetTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.content': {'WeatherWidgetContent'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.content_template': {'WeatherWidgetContentTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display': {'WeatherWidgetContentLayoutInformationToDisplay'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_left_area': {'WeatherWidgetContentLayoutInformationToDisplayLeftArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_name_area': {'WeatherWidgetContentLayoutInformationToDisplayNameArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_sla_area': {'WeatherWidgetContentLayoutInformationToDisplaySlaArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_top_right_area': {'WeatherWidgetContentLayoutInformationToDisplayTopRightArea'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.layout': {'WeatherWidgetContentLayout'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.weather_widget_item': {'WeatherWidgetItem'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.weather_widget': {'WeatherWidget'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.weather_widget_template': {'WeatherWidgetTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget': {'Widget'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget_content': {'WidgetContent'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget_content_template': {'WidgetContentTemplate'},  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget_template': {'WidgetTemplate'},  # noqa: Auto-generated
}  # type: Dict[str, Set[str]]
