#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.component.select import SelectComp
from .option_distributor import instance_option_distributor
from shinken.misc.type_hint import NoReturn
from shinkensolutions.api.synchronizer import ComponentManagerSyncui


class SelectorDistributor(object):
    def __init__(self):
        # type: ()-> None
        self.contents = {}


    def add_element(self, selector):
        # type: (SelectComp)-> NoReturn
        self.contents[selector.get_id()] = selector


    def get_element(self, _id_):
        # type: (str)-> SelectComp
        return self.contents[_id_]


    def find_element(self, _id_):
        # type: (str)-> SelectComp
        if _id_ not in self.contents:
            _options = instance_option_distributor.find_element(_id_)
            _selector = SelectComp(ComponentManagerSyncui.get_translate_component().translator(), _options.entries, _id_)
            _selector.set_label(_options.entries[0].get_label())
            self.add_element(_selector)
        return self.get_element(_id_)



instance_selector_distributor = SelectorDistributor()
