#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import Dict, NoReturn
from shinkensolutions.api.synchronizer import ShinkenObject
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.component.input import InputStringComp
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.list.filter import FilterList
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.button.generic_button import GenericButton
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.html.tag import TagHtml


ShinkenObjectType = str  # type of shinken_object_type . For type hint.
ShinkenObjectName = str  # type of shinken_object_name . For type hint.


class HTML_TYPE(object):
    BUTTON = "button"
    FILTER = "filter"


class HtmlDistributor(object):

    def __init__(self, translate):
        self._translate = translate
        self._content = {}  # type: Dict[ShinkenObjectType, Dict[ShinkenObjectName, ShinkenObject]]


    def add(self, type_object, name, shinken_object):
        # type: (ShinkenObjectType, ShinkenObjectName, ShinkenObject) -> NoReturn
        if type_object not in self._content:
            self._content[type_object] = {}
        self._content[type_object][name] = shinken_object


    def get(self, type_object, name_object):
        # type: (ShinkenObjectType,ShinkenObjectName) -> ShinkenObject
        return self._content[type_object][name_object]


    def add_list_filter(self, name_filter, type_filter="input_string", content=None, current_value="", parent_name="", placeholder=""):
        _to_add = FilterList(self._translate, name_filter, type_filter)
        if not content:
            content = InputStringComp(self._translate, parent_name)
            content.set_value(current_value)
            content.set_place_holder(placeholder)
        _to_add.set_content(content)
        self.add(HTML_TYPE.FILTER, name_filter, _to_add)

    def add_button(self, name_button, label=None):
        _to_add = GenericButton(self._translate, name_button)
        _to_add.set_label(label)
        _to_add.set_tag(TagHtml('div', internal_class='shinken-button-container'))
        _to_add.add_attribute('data-name="reload_rules"')
        self.add(HTML_TYPE.BUTTON, name_button, _to_add)
