#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn


class TagHtml(object):
    def __init__(self, tag, internal_class='', attribute=''):
        # type: (str, str, str)-> NoReturn
        self._tag = tag
        self._internal_class = internal_class
        self._attribute = attribute


    def set_tag(self, to_set):
        # type: (str)-> NoReturn
        self._tag = to_set


    def set_class(self, to_set):
        # type: (str)-> NoReturn
        self._internal_class = to_set


    def add_class(self, to_set):
        # type: (str)-> NoReturn
        self._internal_class = "%s %s" % (self._internal_class, to_set)


    def set_attribute(self, to_set):
        # type: (str)-> NoReturn
        self._attribute = to_set


    def add_attribute(self, to_set):
        # type: (str)-> NoReturn
        self._attribute = "%s %s" % (self._attribute, to_set)


    def get_opening_tag_html(self):
        # type: ()-> str
        return '''<%s class="%s" %s>''' % (self._tag, self._internal_class, self._attribute)


    def get_closing_tag_html(self):
        # type: ()-> str
        return '''</%s>''' % self._tag
