#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ComponentManagerSyncui
from shinkensolutions.toolbox.box_tools_string import ToolsBoxString


class TagTemplate(object):
    def __init__(self, template_name):
        # type: (str) -> None
        self.name = template_name
        self.http_start_time = ComponentManagerSyncui.get_configuration_component().http_start_time


    def get_html(self):
        # type: () -> str
        _to_return = ['''<div class="shinken-tag-label"><table><tr>''']
        if ComponentManagerSyncui.get_configuration_component().is_existing_template_icons(self.name):
            _to_return.append('''<td><img class="shinken-use-icon-img" onerror="$(this).hide()" src="/static/%s/images/sets/%s/tag.png"></td>''' % (self.http_start_time, self.name))
        _to_return.append('''<td class="shinken-label-cell"><span class="shinken-label">%s</span></td>''' % ToolsBoxString.escape_XSS(self.name))
        _to_return.append('''</tr></table></div>''')
        return ''.join(_to_return)
