#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import Callable, NoReturn
from shinkensolutions.api.synchronizer import ShinkenObject
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.object.counter import Counter


class Window(ShinkenObject):
    def __init__(self, name, group_name, _id_=None, extra_class="", label=""):
        # type: (str, str, str, str, str)-> None
        super(Window, self).__init__()
        self.name = name
        self.group_name = group_name
        self._id_ = _id_
        self.extra_class = extra_class
        self.label = label
        self.warning_counter = Counter("shinken-error-counter")
        self.error_counter = Counter("shinken-warning-counter")

    # *****************************   HTML  ************************************************************#

    def get_main_line_html(self):
        # type: ()-> str
        _to_return = ['''<td class="shinken-window-element %s"''' % self.extra_class]
        if self._id_:
            _to_return.append(''' id="%s"''' % self._id_)
        _to_return.append(''' data-name="%s"''' % self.name)
        _to_return.append(''' data-group-name="%s">''' % self.group_name)
        return ''.join(_to_return)

    def get_html(self, format_html=""):
        # type: (str)-> str
        _to_return = [
            '''%s''' % (self.get_main_line_html()),
            '''<span class="shinken-window-element-label">''',
            '''%s''' % self.error_counter.get_html(),
            '''%s''' % self.warning_counter.get_html(),
            '''<span class="shinken-window-label">%s</span>''' % self.label or self.name,
            '''</span>''',
            '''</td>'''
        ]
        return ''.join(_to_return)
