#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer.source.display_origin_item.abstract_display_origin_item import AbstractDisplayOriginItem


class DisplayOriginItemAsTabular(AbstractDisplayOriginItem):
    
    def controller(self, item, item_type):
        if not self.title:
            self.title = self.translator.translate('display_origin_item.element_found_by_source')
        
        for k, v in list(self.raw_data.items()):
            new_key = k.replace('__', '.')
            if new_key != k:
                self.raw_data[new_key] = v
                del self.raw_data[k]
        
        origin_item_properties_description_is_valid = self.source_module.origin_item_description.validation_state.is_valid()
        origin_item_properties_description_has_error = self.source_module.origin_item_description.validation_state.has_error()
        
        prop_description = {} if origin_item_properties_description_has_error else self.source_module.origin_item_description.origin_item_properties_description.get(item_type, {})
        
        return {
            'origin_item_properties_description_is_valid': origin_item_properties_description_is_valid,
            'validation_state'                           : self.source_module.origin_item_description.validation_state,
            'origin_item_properties_description'         : prop_description,
            'title'                                      : self.title,
            'raw_data'                                   : self.raw_data,
            'item_type'                                  : item_type,
            'translate'                                  : self.translator.translate,
        }
