#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved

from shinken.misc.type_hint import Dict, NoReturn
from shinkensolutions.api.synchronizer.source.route.route import AbstractRoute


class RouteContainer(object):
    
    def __init__(self):
        self._routes = {}  # type: Dict[unicode, AbstractRoute]
    
    
    def __iter__(self):
        return iter(self._routes.values())
    
    
    def add(self, route_name, route):
        # type: (unicode, AbstractRoute) -> NoReturn
        self._routes[route_name] = route
    
    
    def get(self, route_name):
        return self._routes[route_name]
    
    
    def __str__(self):
        return 'RouteContainer:[' \
               'routes:[%s],' \
               ']' % \
               (
                   self._routes,
               )
    
    
    def __repr__(self):
        return self.__str__()
