#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from ctypes import c_bool
from multiprocessing import Value


class SourceInfo(object):
    def __init__(self):
        self._import_in_progress = Value(c_bool, False)


    @property
    def import_in_progressed(self):
        return self._import_in_progress.value


    @import_in_progressed.setter
    def import_in_progressed(self, value):
        self._import_in_progress.value = value
