#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2019 :
#    Shinken solutions

import os

from .common import get_real_path_from_source


class File:
    def __init__(self, path, name=""):
        path = get_real_path_from_source(path)
        self.path = path
        self.name = name
        self.priority = 999
        self.shinken_lib = False
        self.full_path = os.path.join(path, name)
        self.is_folder = os.path.isdir(self.full_path)
        self.children = Files()
        if not self.is_folder:
            self.load_lines()
    
    
    def getChildren(self):
        return self.children.getFiles()
    
    
    def match_filter(self, type_filter, to_test):
        if type_filter == 'equals':
            return self.name == to_test
        if type_filter == 'different':
            return self.name != to_test
        if type_filter == 'contains':
            return self.name.find(to_test) != -1
        if type_filter == 'has_lib':
            return self.shinken_lib == to_test
        if type_filter == 'all':
            return True
        return False
    
    
    def load_lines(self):
        _to_read = open(self.full_path, "rb")
        _buffer = _to_read.read()
        self.lines = _buffer.splitlines()
        _to_read.close()
        print(self.full_path)
        for i in range(min(10, len(self.lines))):
            if self.lines[i].startswith("//priority"):
                self.priority = int(self.lines[i].replace("//priority", ""))
            if self.lines[i].startswith("//__lib__"):
                self.shinken_lib = self.lines[i].replace("//__lib__", "").strip()
            if self.lines[i].startswith("/* __lib__"):
                self.shinken_lib = self.lines[i].replace("/* __lib__", "").strip()
                self.shinken_lib = self.shinken_lib.replace("*/", "").strip()
    
    
    def get_file_content(self):
        import re
        _to_return = ""
        # _to_return += "//******************************  START  %s   **************************\n" % self.name
        # _to_return += "// full path:  %s \n" % self.full_path
        for _line in self.lines:
            _current = re.sub('[\t]+', ' ', _line)
            if _current == "'use strict';":
                continue
            if _current.strip().startswith("//"):
                continue
            if _current.strip().startswith("/* __lib__"):
                continue
            if _current:
                _to_return += "%s\n" % _current
        # _to_return += "//******************************  END  %s   **************************\n\n" % self.name
        return _to_return
    
    
    def save_content(self):
        _to_write = open(self.full_path, "wb")
        _to_write.write(self.get_file_content())
        _to_write.close()
    
    
    def __repr__(self):
        return '"%s"  [%s]\n' % (self.full_path, self.is_folder)


class Files:
    def __init__(self):
        self.list = []
    
    
    def append(self, to_add):
        if to_add.is_folder:
            self.appends(to_add.getChildren())
        else:
            self.list.append(to_add)
    
    
    def appends(self, children):
        for index, _current in enumerate(children):
            self.append(_current)
    
    
    def getFiles(self):
        return self.list
    
    
    def __repr__(self):
        return '"%s"' % self.list
