#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn, Any


class OPTIONS_CONSTANT(object):
    SHINKEN_ELEMENT = 'shinken-element'
    SHINKEN_INHERITANCE_OPTION = 'shinken-inheritance-option'
    SHINKEN_NO_CHANGE = '__NO_CHANGE__'
    SHINKEN_DEFAULT_LABEL = '__DEFAULT_LABEL__'
    SHINKEN_IS_ALWAYS_VISIBLE = 'shinken-is-always-visible-option'


class OptionSelectAbstractComp(object):
    def __init__(self, value):
        # type: (Any) -> NoReturn
        self._is_selected = False
        self._value = value
        self._text = ''
        self._label = ''
    
    
    # *****************************   GETTER SETTER  ************************************************************#
    def set_is_selected(self, to_set):
        # type: (bool)-> NoReturn
        self._is_selected = to_set
    
    
    def get_value(self):
        # type: () -> unicode
        return self._value
    
    
    def set_text(self, to_set):
        # type: (unicode) -> NoReturn
        self._text = to_set
    
    
    def set_label(self, to_set):
        # type: (unicode) -> NoReturn
        self._label = to_set
    
    
    def get_label(self):
        # type: () -> unicode
        return self._label
    
    
    def get_id(self):
        raise NotImplementedError()
    
    
    # *****************************   HTML  ************************************************************#
    def get_html(self, class_to_add=''):
        # type: (unicode) -> unicode
        raise NotImplementedError()
    
    
    # *****************************   OTHER  ************************************************************#
    @staticmethod
    def build_id(group, name):
        # type: (unicode, unicode) -> unicode
        return '%s__%s' % (group, name)


class OptionSelectComp(OptionSelectAbstractComp):
    def __init__(self, group, value, label=''):
        # type: (unicode, unicode, unicode) -> NoReturn
        super(OptionSelectComp, self).__init__(value)
        self._group = group
        self._id = OptionSelectAbstractComp.build_id(self._group, self._value)
        self._label = label or self._value
        self._text = self._label
        self._parents = []
        self._extra_class = ''
    
    
    # *****************************   GETTER SETTER  ************************************************************#
    
    def get_id(self):
        # type: () -> unicode
        return self._id
    
    
    def add_parent(self, to_add):
        # type: (str)-> NoReturn
        self._parents.append(to_add)
    
    
    def set_extra_class(self, to_set):
        # type: (str)-> NoReturn
        self._extra_class = to_set
    
    
    # *****************************   HTML  ************************************************************#
    def get_html(self, class_to_add=''):
        # type: (str)-> str
        _data_list = 'data-parents="%s"' % ','.join(self._parents) if len(self._parents) else ''
        
        _to_return = '<div class="shinken-option %s %s"' \
                     ' data-group="%s"' \
                     ' data-key-name="%s"' \
                     ' data-key-label="%s"' \
                     ' %s ' \
                     ' onmouseenter="MANAGER.EventManager.mouseEnter(event)"' \
                     ' onclick="MANAGER.EventManager.clickOnItemSelector(event, this)" >' \
                     '<div class="shinken-selector-label shinken-space">%s</div>' \
                     '</div>' \
                     % (
                         class_to_add,
                         self._extra_class,
                         self._group,
                         self._value,
                         self._label,
                         _data_list,
                         self._text
                     )
        return _to_return
