#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import Dict, NoReturn, TYPE_CHECKING, Any
# from ..component.check_box.check_box_with_label import CheckBoxCompWithLabel
from ..component.input import InputStringComp
# from ..list.filter import FilterList
from ..object.html.tag import TagHtml
from ..object.shinken_object import ShinkenObject, ShinkenObjectContainer

# from ..table.generic_table import TableGeneric


if TYPE_CHECKING:
    from shinkensolutions.common_ui.factory.ui_factory_component import UiFactoryComponent

ShinkenObjectType = str or str  # type of shinken_object_type. For type hint.
ShinkenObjectName = str or str  # type of shinken_object_name. For type hint.


class HTML_TYPE(object):
    BUTTON = 'button'
    FILTER = 'filter'
    PROPERTY = 'property'
    OTHER = 'other'
    INPUT = 'input'
    CHECKBOX = 'check_box'
    TABLE = 'table'
    HTML = 'html'


class HtmlDistributor(object):
    
    def __init__(self, ui_factory_component):
        # type: (UiFactoryComponent) -> NoReturn
        self._ui_factory_component = ui_factory_component
        self._content = {}  # type: Dict[ShinkenObjectType, Dict[ShinkenObjectName, ShinkenObject]]
    
    
    def add(self, type_object, name, shinken_object):
        # type: (ShinkenObjectType, ShinkenObjectName, ShinkenObject) -> NoReturn
        if not shinken_object:
            return
        if type_object not in self._content:
            self._content[type_object] = {}
        self._content[type_object][name] = shinken_object
    
    
    def get(self, type_object, name_object):
        # type: (ShinkenObjectType,ShinkenObjectName) -> ShinkenObject
        return self._content[type_object][name_object]
    
    
    def has(self, type_object, name_object):
        # type: (ShinkenObjectType,ShinkenObjectName) -> bool
        if type_object not in self._content:
            return False
        
        if name_object not in self._content[type_object]:
            return False
        
        return True
    
    
    def get_html(self, type_object, name_object):
        # type: (ShinkenObjectType,ShinkenObjectName) -> str
        if self.has(type_object, name_object):
            return self.get(type_object, name_object).get_html()
        else:
            return ''
    
    
    # def add_list_filter(self, key, type_filter=u'input_string', content=None, current_value=u'', name=u'', placeholder=u''):
    #     # type: (unicode, unicode, Any, unicode, unicode, unicode) -> NoReturn
    #     _to_add = FilterList(self._translate, key, type_filter)
    #     if not content:
    #         content = InputStringComp(self._translate, name=name)
    #         content.set_value(current_value)
    #         content.set_place_holder(placeholder)
    #     _to_add.set_content(content)
    #     self.add(HTML_TYPE.FILTER, key, _to_add)
    #     return _to_add
    
    def add_button(self, key, data_name='', label=None):
        # type: (unicode, unicode, Any) -> NoReturn
        if not data_name:
            data_name = key
        _to_add = self._ui_factory_component.build_generic_button(data_name)
        _to_add.set_label(label)
        _to_add.set_tag(TagHtml('div', internal_class='shinken-button-container'))
        _to_add.add_data('name', data_name)
        self.add(HTML_TYPE.BUTTON, key, _to_add)
        return _to_add
    
    
    # def add_immutable_html(self, key):
    #     # type: (str) -> NoReturn
    #     _to_add = instance_immutable_html_distributor.find_element(key)
    #     self.add(HTML_TYPE.OTHER, key, _to_add)
    #     return _to_add
    #
    #
    def add_input(self, key, current_value='', name='', placeholder=''):
        # type: (str, str, str, str)-> InputStringComp
        _to_add = InputStringComp(self._translate, name=name)
        _to_add.set_value(current_value)
        _to_add.set_place_holder(placeholder)
        self.add(HTML_TYPE.INPUT, key, _to_add)
        return _to_add
    
    
    #
    # def add_check_box_with_label(self, key, name=u'', label=u''):
    #     # type: (unicode, unicode, Any)-> CheckBoxCompWithLabel
    #     _to_add = CheckBoxCompWithLabel(name, LabelHtml(label=label))
    #     self.add(HTML_TYPE.CHECKBOX, key, _to_add)
    #     return _to_add
    #
    #
    # def add_table(self, key, data=None, title='', class_name='', header=None):
    #     # type: (str or unicode, List, str or unicode, str or unicode, List[unicode]) -> TableGeneric
    #     _to_add = TableGeneric(translate=self._translate, data=data, title=title, class_name=class_name, header=header)
    #     self.add(HTML_TYPE.TABLE, key, _to_add)
    #     return _to_add
    
    def add_html(self, key, html):
        # type: (unicode, str) -> ShinkenObject
        _to_add = ShinkenObjectContainer(html)
        self.add(HTML_TYPE.HTML, key, _to_add)
        return _to_add
