from shinkensolutions.common_ui.object.shinken_object import ShinkenObject
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import List


class OneLineTableHtml(ShinkenObject):
    def __init__(self, *args):
        # type: ( List[unicode])-> None
        super(OneLineTableHtml, self).__init__(None)
        self._content = args
    
    
    def get_html(self):
        # type: () -> unicode
        _to_return = ['''<table class="shinken-one-line-table"><tr>''']
        for index, cell in enumerate(self._content):
            _to_return.append('''<td class="shinken-cell-%s">%s</td>''' % (index, cell))
        _to_return.append('''</tr></table>''')
        return ''.join(_to_return)
