#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import NoReturn
from ...object.shinken_object import ShinkenObject


class TagGeneric(ShinkenObject):
    def __init__(self, value):
        # type: (unicode)-> NoReturn
        super(TagGeneric, self).__init__()
        self.value = value
        self._class = 'shinken-container-tag'
    
    
    def get_html(self):
        # type: ()-> unicode
        _to_return = [
            '''<table %s>''' % self.get_object_tag_html(skip_tooltip=True),
            '''<tbody %s>''' % self.tooltip.get_html(),
            '''<tr class="text-break-all-pre-line">''',
            '''<td class="content">''',
            '''<span class="title shinken-space">%s</span>''' % self.value,
            '''</td>''',
            '''</tr>''',
            '''</tbody>''',
            '''</table>'''
        ]
        return ''.join(_to_return)
