#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING
from .table_cell import TableCell, TableCellHeader
from ..object.shinken_object import ShinkenObject

if TYPE_CHECKING:
    from shinkensolutions.api.synchronizer import TranslatePart
    from shinken.misc.type_hint import NoReturn, List, Optional


class TableLine(ShinkenObject):
    def __init__(self, line_data=None, translate=None):
        # type: (List[unicode], TranslatePart)-> NoReturn
        super(TableLine, self).__init__(translate)
        self.add_class('shinken-list-line')
        self._cells = None  # type: Optional[List[TableCell]]
        self.compute_data(line_data)
    
    
    def compute_data(self, to_compute):
        # type: (List[unicode]) -> NoReturn
        self._cells = []
        if to_compute is None:
            return
        for _cell in to_compute:
            _to_add = TableCell(_cell, translate=self.translate)
            self._cells.append(_to_add)
    
    
    def get_cell(self, index):
        # type: (int) -> TableCell
        return self._cells[index]
    
    
    # ****************************************************** GETTER SETTER  ***************************************
    
    def get_nb_cell(self):
        # type: () -> int
        return len(self._cells) if self._cells else 0
    
    
    def add_class_to_cells(self, class_to_add):
        # type: (unicode) -> NoReturn
        for _c in self._cells:
            _c.add_class(class_to_add)
    
    
    def add_class_content_to_cells(self, class_to_add):
        # type: (unicode) -> NoReturn
        for _c in self._cells:
            _c.add_class_content(class_to_add)
    
    
    def add_cell(self, table_cell):
        # type: (TableCell)-> NoReturn
        self._cells.append(table_cell)
    
    
    def add_class_container(self, to_set):
        # type: (unicode) -> NoReturn
        raise NotImplementedError()
    
    
    # ****************************************************** HTML  ***************************************
    
    def get_html(self):
        # type: () -> unicode
        _to_return = ['''<tr %s>''' % self.get_object_tag_html()]
        for _cell in self._cells:
            _to_return.append(_cell.get_html())
        _to_return.append('''</tr>''')
        return ''.join(_to_return)


class TableLineHeader(TableLine):
    def __init__(self, line_data=None, translate=None):
        # type: (List[unicode], TranslatePart)-> NoReturn
        super(TableLineHeader, self).__init__(line_data=line_data, translate=translate)
        self._class = 'shinken-header-line'
    
    
    def compute_data(self, to_compute):
        # type: (List[unicode])-> NoReturn
        self._cells = []
        if to_compute is None:
            return
        for _cell in to_compute:
            _to_add = TableCellHeader(_cell, translate=self.translate)
            self._cells.append(_to_add)
    
    
    def add_class_container(self, to_set):
        # type: (unicode) -> NoReturn
        raise NotImplementedError()


class TableLineTbody(TableLine):
    def __init__(self, line_data=None, translate=None):
        # type: (List[unicode], TranslatePart)-> NoReturn
        super(TableLineTbody, self).__init__(line_data=line_data, translate=translate)
        self._class = ''
    
    
    def add_class_container(self, to_set):
        # type: (unicode)-> NoReturn
        raise NotImplementedError()
