#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from ..object.counter import Counter
from ..object.shinken_object import ShinkenObject


class Window(ShinkenObject):
    def __init__(self, name, group_name, _id_=None, extra_class='', label=''):
        # type: (unicode, unicode, unicode, unicode, unicode) -> None
        super(Window, self).__init__()
        self.name = name
        self.group_name = group_name
        self._id_ = _id_
        self.extra_class = extra_class
        self.extra_attribute = ''
        self.label = label
        self.warning_counter = Counter('shinken-error-counter')
        self.error_counter = Counter('shinken-warning-counter')
    
    
    # *****************************   HTML  ************************************************************#
    
    def get_main_line_html(self):
        # type: () -> unicode
        _to_return = ['''<td class="shinken-window-element %s" %s''' % (self.extra_class, self.extra_attribute)]
        if self._id_:
            _to_return.append(''' id="%s"''' % self._id_)
        _to_return.append(''' data-name="%s"''' % self.name)
        _to_return.append(''' data-group-name="%s">''' % self.group_name)
        return ''.join(_to_return)
    
    
    def get_html(self):
        # type: () -> unicode
        _to_return = [
            '''%s''' % (self.get_main_line_html()),
            '''<span class="shinken-window-element-label">''',
            '''%s''' % self.error_counter.get_html(),
            '''%s''' % self.warning_counter.get_html(),
            '''<span class="shinken-window-label">%s</span>''' % self.label or self.name,
            '''</span>''',
            '''</td>'''
        ]
        return ''.join(_to_return)
