#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.
from abc import ABCMeta

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver import AbstractDataHubDriver, AbstractDataHubDriverConfig

if TYPE_CHECKING:
    from shinken.misc.type_hint import List, Any


class AbstractDataHubDriverConfigDatabase(AbstractDataHubDriverConfig):
    pass


class AbstractDataHubDriverDatabase(AbstractDataHubDriver, metaclass=ABCMeta):
    def init(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    def get_all_data_id(self):
        # type: () -> List[unicode]
        raise NotImplementedError()
    
    
    def is_data_correct(self, data_id):
        # type: (unicode) -> bool
        raise NotImplementedError()
    
    
    def get_lock(self, data_id):
        # type: (unicode) -> Any
        raise NotImplementedError()
    
    
    def write(self, data_id, data):
        # type: (unicode, Any) -> None
        raise NotImplementedError()
    
    
    def read(self, data_id, log_error=True):
        # type: (unicode, bool) -> Any
        raise NotImplementedError()
    
    
    def remove(self, data_id):
        # type: (unicode) -> None
        raise NotImplementedError()
    
    
    def get_last_modification_date(self, data_id):
        # type: (unicode) -> int
        raise NotImplementedError()
    
    
    def destroy(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    def stop(self):
        # type: () -> None
        raise NotImplementedError()
    
    
    def get_total_size(self):
        # type: () -> int
        raise NotImplementedError()
    
    
    def get_number_of_stored_data(self):
        # type: () -> int
        raise NotImplementedError()
