#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

import json

from shinken.misc.type_hint import TYPE_CHECKING, cast
from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_file import AbstractDataHubDriverFile, AbstractDataHubDriverConfigFile
from shinkensolutions.data_hub.data_hub_factory.data_hub_factory import DataHubFactory

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any
    from shinken.log import PartLogger
    from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver import AbstractDataHubDriverConfig
    from shinkensolutions.data_hub.data_hub import DataHubConfig


class DataHubDriverConfigJson(AbstractDataHubDriverConfigFile):
    def __init__(self, base_directory, data_location_name, namespace='', daemon_name='', module_name='', submodule_name='', file_prefix='shinken_'):
        # type: ( unicode, unicode, unicode, unicode, unicode, unicode, unicode ) -> None
        super(DataHubDriverConfigJson, self).__init__(
            name='JSON',
            namespace=namespace,
            base_directory=base_directory,
            data_location_name=data_location_name,
            daemon_name=daemon_name,
            module_name=module_name,
            submodule_name=submodule_name,
            file_ext='json',
            file_prefix=file_prefix
        )


def data_hub_driver_json_factory(logger, driver_config, _data_hub_config):
    # type: (PartLogger, AbstractDataHubDriverConfig, DataHubConfig) -> DataHubDriverJson
    return DataHubDriverJson(logger, cast(DataHubDriverConfigJson, driver_config))


DataHubFactory.register_driver_factory(DataHubDriverConfigJson, data_hub_driver_json_factory)


class DataHubDriverJson(AbstractDataHubDriverFile):
    
    def __init__(self, logger, driver_config):
        # type: (PartLogger, DataHubDriverConfigJson)-> None
        super(DataHubDriverJson, self).__init__(logger, driver_config)
    
    
    def _serialized_data(self, data):
        # type: (Any) -> str
        return json.dumps(data)
    
    
    def _deserialized_data(self, serialized_data):
        # type: (str) -> Any
        return json.loads(serialized_data)
