#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

import mmap

from shinken.misc.os_utils import ShinkenFileNotFoundError
from shinken.misc.type_hint import TYPE_CHECKING, cast
from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_file import AbstractDataHubDriverFile, AbstractDataHubDriverConfigFile
from shinkensolutions.data_hub.data_hub_exception.data_hub_exception import DataHubItemNotFound
from shinkensolutions.data_hub.data_hub_factory.data_hub_factory import DataHubFactory

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinken.misc.type_hint import Any
    from shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver import AbstractDataHubDriverConfig
    from shinkensolutions.data_hub.data_hub import DataHubConfig


class DataHubDriverConfigMmapFile(AbstractDataHubDriverConfigFile):
    def __init__(self, base_directory, data_location_name, namespace='', daemon_name='', module_name='', submodule_name='', file_ext='', file_prefix='shinken_'):
        # type: ( unicode, unicode, unicode, unicode, unicode, unicode, unicode, unicode) -> None
        super(DataHubDriverConfigMmapFile, self).__init__(
            name='PLAIN_FILE',
            namespace=namespace,
            base_directory=base_directory,
            data_location_name=data_location_name,
            daemon_name=daemon_name,
            module_name=module_name,
            submodule_name=submodule_name,
            file_ext=file_ext,
            file_prefix=file_prefix
        )


def data_hub_driver_plain_file_factory(logger, driver_config, _data_hub_config):
    # type: (PartLogger, AbstractDataHubDriverConfig, DataHubConfig) -> DataHubDriverMmapFile
    return DataHubDriverMmapFile(logger, cast(DataHubDriverConfigMmapFile, driver_config))


DataHubFactory.register_driver_factory(DataHubDriverConfigMmapFile, data_hub_driver_plain_file_factory)


class DataHubDriverMmapFile(AbstractDataHubDriverFile):
    
    def read(self, data_id, log_error=True):
        # type: (unicode, bool) -> Any
        return self.read_raw(data_id, log_error=log_error)
    
    
    def read_raw(self, data_id, log_error=True):
        # type: (unicode, bool) -> Any
        try:
            file_path = self._check_path_before_read(data_id, self._logger_reader)
            with open(file_path, 'r+b') as file_handler:
                _data = mmap.mmap(file_handler.fileno(), 0)
            return _data
        except ShinkenFileNotFoundError:
            raise DataHubItemNotFound(self._data_type, data_id)
        except Exception as e:
            raise DataHubItemNotFound(message=e.message)
    
    
    def _deserialized_data(self, serialized_data):
        return serialized_data
    
    
    def _serialized_data(self, data):
        return data
    
    
    def __init__(self, logger, driver_config):
        # type: (PartLogger, DataHubDriverConfigMmapFile)-> None
        super(DataHubDriverMmapFile, self).__init__(logger, driver_config)
