# !/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
from abc import ABCMeta, abstractmethod

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, List


class FilteredObject(object):
    def __init__(self, filtered_list, additional_info):
        # type: (List[Any], Any) -> None
        self.filtered_list = filtered_list
        self.additional_info = additional_info


class AbstractFilter(object, metaclass=ABCMeta):
    def __init__(self):
        self._filter_items_to_apply = []  # type: List[Any]
    
    
    def add_filter_item_to_apply(self, filter_item):
        # type: (Any) -> None
        self._filter_items_to_apply.append(filter_item)
    
    
    def get_registered_filter_items(self):
        # type: () -> List[Any]
        return self._filter_items_to_apply
    
    
    @abstractmethod
    def get_filtered_object(self, object_to_filter):
        # type: (Any) -> FilteredObject
        raise NotImplementedError()
